/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CentrifugeRecipeCategory
implements IRecipeCategory<CentrifugeRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public CentrifugeRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/centrifuge_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.CENTRIFUGE.get()));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ProductiveBeesJeiPlugin.CATEGORY_CENTRIFUGE_UID;
    }

    @Nonnull
    public Class<? extends CentrifugeRecipe> getRecipeClass() {
        return CentrifugeRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jei.productivebees.centrifuge");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull CentrifugeRecipe recipe, @Nonnull IIngredients ingredients) {
        ingredients.setInputIngredients((List)Lists.newArrayList((Object[])new Ingredient[]{recipe.ingredient}));
        ArrayList outputList = new ArrayList();
        recipe.getRecipeOutputs().forEach((stack, value) -> {
            ArrayList innerList = new ArrayList();
            IntStream.range(value.get(0).m_7047_(), value.get(1).m_7047_() + 1).forEach(i -> {
                ItemStack newStack = stack.m_41777_();
                newStack.m_41764_(i);
                innerList.add(newStack);
            });
            outputList.add(innerList);
        });
        ingredients.setOutputLists(VanillaTypes.ITEM, outputList);
        Pair<Fluid, Integer> fluid = recipe.getFluidOutputs();
        if (fluid != null && (Integer)fluid.getSecond() > 0) {
            int fluidAmount = (Integer)fluid.getSecond() < 250 ? (Integer)fluid.getSecond() * 4 : (Integer)fluid.getSecond();
            ingredients.setOutput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)fluid.getFirst(), fluidAmount));
        }
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull CentrifugeRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        itemStacks.init(0, true, 4, 26);
        int startX = 68;
        int startY = 26;
        int offset = ingredients.getInputs(VanillaTypes.ITEM).size();
        List itemOutputs = ingredients.getOutputs(VanillaTypes.ITEM);
        if (itemOutputs.size() > 0) {
            IntStream.range(0, itemOutputs.size()).forEach(i -> itemStacks.init(i + offset, false, startX + i * 18, startY + (int)Math.floor((float)i / 3.0f) * 18));
        }
        itemStacks.set(ingredients);
        List fluidOutputs = ingredients.getOutputs(VanillaTypes.FLUID);
        if (fluidOutputs.size() > 0) {
            IntStream.range(itemOutputs.size(), itemOutputs.size() + fluidOutputs.size()).forEach(i -> fluidStacks.init(i + offset, false, startX + i * 18 + 1, startY + (int)Math.floor((float)i / 3.0f) * 18 + 1));
        }
        fluidStacks.set(ingredients);
        ArrayList<TextComponent> chances = new ArrayList<TextComponent>();
        ArrayList<TranslatableComponent> amounts = new ArrayList<TranslatableComponent>();
        recipe.getRecipeOutputs().forEach((stack, value) -> {
            int chance = value.get(2).m_7047_();
            if (chance < 100) {
                chances.add((TextComponent)new TranslatableComponent("productivebees.centrifuge.tooltip.chance", new Object[]{chance < 1 ? "<1%" : chance + "%"}));
            } else {
                chances.add(new TextComponent(""));
            }
            if (value.get(0) != value.get(1)) {
                amounts.add(new TranslatableComponent("productivebees.centrifuge.tooltip.amount", new Object[]{value.get(0).m_7047_() + " - " + value.get(1).m_7047_()}));
            } else {
                amounts.add((TranslatableComponent)new TextComponent(""));
            }
        });
        Pair<Fluid, Integer> fluid = recipe.getFluidOutputs();
        if (fluid != null) {
            chances.add(new TextComponent(""));
            amounts.add(new TranslatableComponent("productivebees.centrifuge.tooltip.amount", new Object[]{fluid.getSecond() + "mB"}));
        }
        itemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (!input) {
                if (!chances.isEmpty() && chances.size() >= slotIndex && !((Component)chances.get(slotIndex - 1)).getString().isEmpty()) {
                    tooltip.add((Component)chances.get(slotIndex - 1));
                }
                if (!amounts.isEmpty() && amounts.size() >= slotIndex && !((Component)amounts.get(slotIndex - 1)).getString().isEmpty()) {
                    tooltip.add((Component)amounts.get(slotIndex - 1));
                }
            }
        });
        fluidStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (!chances.toString().isEmpty() && chances.size() >= slotIndex && !((Component)chances.get(slotIndex - 1)).getString().isEmpty()) {
                tooltip.add((Component)chances.get(slotIndex - 1));
            }
            if (!amounts.toString().isEmpty() && amounts.size() >= slotIndex && !((Component)amounts.get(slotIndex - 1)).getString().isEmpty()) {
                tooltip.add((Component)amounts.get(slotIndex - 1));
            }
        });
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CentrifugeRecipe recipe, List<? extends IFocus<?>> focuses) {
        Pair<Fluid, Integer> fluid;
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 5, 27).addItemStacks(Arrays.stream(recipe.ingredient.m_43908_()).toList())).setSlotName("ingredient");
        int startX = 68;
        int startY = 26;
        int[] i = new int[]{0};
        if (recipe.getRecipeOutputs().size() > 0) {
            recipe.getRecipeOutputs().forEach((stack, value) -> {
                ArrayList innerList = new ArrayList();
                IntStream.range(value.get(0).m_7047_(), value.get(1).m_7047_() + 1).forEach(u -> {
                    ItemStack newStack = stack.m_41777_();
                    newStack.m_41764_(u);
                    innerList.add(newStack);
                });
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, startX + i[0] * 18 + 1, startY + (int)Math.floor((float)i[0] / 3.0f) * 18 + 1).addItemStacks(innerList)).addTooltipCallback((recipeSlotView, tooltip) -> {
                    int chance = value.get(2).m_7047_();
                    if (chance < 100) {
                        tooltip.add(new TranslatableComponent("productivebees.centrifuge.tooltip.chance", new Object[]{chance < 1 ? "<1%" : chance + "%"}));
                    } else {
                        tooltip.add(new TextComponent(""));
                    }
                    if (value.get(0) != value.get(1)) {
                        tooltip.add(new TranslatableComponent("productivebees.centrifuge.tooltip.amount", new Object[]{value.get(0).m_7047_() + " - " + value.get(1).m_7047_()}));
                    } else {
                        tooltip.add(new TextComponent(""));
                    }
                }).setSlotName("output" + i[0]);
                i[0] = i[0] + 1;
            });
        }
        if ((fluid = recipe.getFluidOutputs()) != null && (Integer)fluid.getSecond() > 0) {
            int fluidAmount = (Integer)fluid.getSecond() < 250 ? (Integer)fluid.getSecond() * 4 : (Integer)fluid.getSecond();
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, startX + i[0] * 18 + 1, startY + (int)Math.floor((float)i[0] / 3.0f) * 18 + 1).addIngredient(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)fluid.getFirst(), fluidAmount))).addTooltipCallback((recipeSlotView, tooltip) -> tooltip.add(new TranslatableComponent("productivebees.centrifuge.tooltip.amount", new Object[]{fluid.getSecond() + "mB"}))).setSlotName("output" + i[0]);
        }
    }
}

